package cn.com.duiba.live.statistics.service.api.remoteservice.treasure;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.treasure.LiveTreasureStatisticDto;

import java.util.List;

/**
 * 直播宝箱统计service
 *
 * @author 吴文哲
 * @date 2021/4/9 11:12 上午
 **/
@AdvancedFeignClient
public interface RemoteLiveTreasureStatisticApiService {

    /**
     * 宝箱福利统计信息列表
     * 以参数中的信息为准,对db中的数据最初相应的新增/修改/物理删除
     *
     * @param treasureStatisticDtos 宝箱福利统计数据
     * @return 新增结果
     */
    boolean saveLiveTreasureStatisticDto(List<LiveTreasureStatisticDto> treasureStatisticDtos);

    /**
     * 新增领取人数
     *
     * @param treasureConfRelatedId 宝箱配置id tb_live_treasure_conf_related.id
     * @param receiveNum     领取人数
     * @return 执行结果
     */
    boolean increaseReceiveNum(Long treasureConfRelatedId, Integer receiveNum);

    /**
     * 查询宝箱福利统计信息
     * @param treasureConfRelatedIds 宝箱配置id列表
     * @return 宝箱福利统计信息
     */
    List<LiveTreasureStatisticDto> listStatByRelatedIds(List<Long> treasureConfRelatedIds);
}
