package cn.com.duiba.live.statistics.service.api.remoteservice.videospecaward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.videoSpecAward.VideoSpecAwardConfStatisDto;

import java.util.List;

/**
 * 精彩集锦指定中奖统计
 * @author 吴文哲
 * @date 2021/1/26 9:47 上午
 **/
@AdvancedFeignClient
public interface RemoteVideoSpecAwardConfStatisApiService {

    /**
     * 新增统计数据
     * @param dto 统计对象
     * @return 主键
     */
    Long saveVideoSpecAwardConfStatis(VideoSpecAwardConfStatisDto dto);

    /**
     * 根据代理人id 配置id 新增指定中奖总数量
     * @param agentId 代理人id
     * @param videoConfId 视频配置id
     * @param specNum 指定中奖总数量
     * @return 影响行数
     */
    int updateSpecNum(Long agentId,Long videoConfId,Integer specNum);

    /**
     * 根据代理人id 配置id 新增指定中奖数量
     * @param agentId 直播代理人id
     * @param videoConfId 视频配置id
     * @param increaseNum
     * @return 影响行数
     */
    int increaseWinnerNum(Long agentId,Long videoConfId,Integer increaseNum);

    /**
     * 根据代理人id 配置id 批量查询
     * @param agentId 直播代理人id
     * @param confIds 中奖配置id
     * @return
     */
    List<VideoSpecAwardConfStatisDto> listByAgentIdAndConfIds(Long agentId, List<Long> confIds);
}
