package cn.com.duiba.live.statistics.service.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.agent.LiveStatisticsAgentExtDto;

import java.util.List;

/**
 * @author 吴文哲
 * @date 2021/1/4 4:11 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsAgentExtApiService {



    /**
     * 批量查询
     *
     * @param liveId 直播id
     * @param agentIds 代理人id集合
     * @param actionTypes 行为集合 {@link cn.com.duiba.kjy.livecenter.api.enums.clue.LiveVisitorActionEnums}
     * @return 线索集合
     */
    List<LiveStatisticsAgentExtDto> selectListByAgentIdsAndActionTypes(Long liveId, List<Long> agentIds, List<Integer> actionTypes);

}
