package cn.com.duiba.live.statistics.service.api.remoteservice.company;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.company.LiveCompanyVideoStatsDto;

import java.util.List;
import java.util.Set;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-09-25 18:04
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyVideoStatsApiService {

    /**
     * 根据视频id查询
     * @param videoId 视频id
     * @return 视频统计信息
     */
    LiveCompanyVideoStatsDto findByVideoId(Long videoId);

    /**
     * 根据视频id集合查询
     * @param videoIds 视频id集合
     * @return 视频统计信息
     */
    List<LiveCompanyVideoStatsDto> findByVideoIds(Set<Long> videoIds);

    /**
     * 批量更新数据
     * @param dtoList 视频信息
     * @return 执行结果
     */
    int batchAddWatchNumAndShareNum(List<LiveCompanyVideoStatsDto> dtoList);

    /**
     * 添加点赞数
     * @param videoId 视频id
     * @param likeNum 点赞数
     * @return 执行结果
     */
    int addLikeNum(Long videoId, Integer likeNum);

    /**
     * 新增
     * @param entity 直播公司精彩视频统计
     * @return 执行结果
     */
    int insert(LiveCompanyVideoStatsDto entity);

}
