package cn.com.duiba.live.statistics.service.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.live.LiveStatisticsDto;

import java.util.List;

/**
 * 直播间统计
 * @author 吴文哲
 * @date 2021/1/4 1:59 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsApiService {

    /**
     * 根据直播id查找
     * @param liveId
     * @return
     */
    LiveStatisticsDto findByLiveId(Long liveId);


    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播统计-每场直播维度统计信息
     */
    LiveStatisticsDto selectById(Long id);


    /**
     * 新增
     * @param dto 直播统计-每场直播维度统计信息
     * @return 执行结果
     */
    int insert(LiveStatisticsDto dto);



    /**
     * 根据直播间id列表 查询统计数据
     * @param liveIds
     * @return
     */
    List<LiveStatisticsDto> findByLiveIds(List<Long> liveIds);

    /**
     * 更新统计信息
     * @param liveStatisticsDto
     * @return
     */
    Integer update(LiveStatisticsDto liveStatisticsDto);

    /**
     * 自增失败重试次数
     * @param liveId
     * @return
     */
    Integer increaseRetryTimes(Long liveId);

}
