package cn.com.duiba.live.statistics.service.api.remoteservice.reward;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.statistics.service.api.dto.reward.LiveRewardAmountStatsDto;

/**
 * 直播奖品签收金额统计表
 * @author lizhi
 * @date 2021/3/18 5:16 下午
 */
@AdvancedFeignClient
public interface RemoteLiveRewardAmountStatsService {

    /**
     * 根据唯一约束查询
     * @param liveId 直播ID
     * @param agentId 代理人ID
     * @param statType 类型
     * @see cn.com.duiba.live.statistics.service.api.enums.reward.LiveRewardStatTypeEnum
     * @return 直播奖品签收金额统计
     */
    LiveRewardAmountStatsDto selectUnique(Long liveId, Long agentId, Integer statType);

    /**
     * 新增或增加金额
     * @param dto 直播奖品签收金额统计
     * @return 执行结果
     */
    int insertOrIncrAmount(LiveRewardAmountStatsDto dto);
}
