package cn.com.duiba.local.autoconfigure.web.reactive;

import cn.com.duiba.local.wolf.entity.JsonResult;
import cn.com.duiba.local.wolf.message.BaseError;
import com.alibaba.csp.sentinel.adapter.gateway.sc.callback.BlockRequestHandler;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebFluxAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.function.server.ServerResponse;

import static org.springframework.web.reactive.function.BodyInserters.fromValue;

/**
 * WebFlux熔断处理
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Slf4j
@Configuration
@AutoConfigureAfter(WebFluxAutoConfiguration.class)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnClass(WebFluxConfigurer.class)
public class WebFluxBlockAutoConfiguration {
    @Bean
    public BlockRequestHandler blockRequestHandler() {
        log.info("1");
        log.info("1");
        log.info("1");
        log.info("1");
        log.info("1");
        return (exchange, t) -> ServerResponse.status(429).contentType(MediaType.APPLICATION_JSON)
                .body(fromValue(JsonResult.fail(BaseError.API_LIMIT.getCode(), "接口调用超过限制")));
    }
}