/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.web.servlet;

import cn.com.duiba.local.ext.exception.BizException;
import cn.com.duiba.local.wolf.entity.JsonResult;
import cn.com.duiba.local.wolf.message.BaseError;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={Servlet.class, DispatcherServlet.class, WebMvcConfigurer.class})
@RestControllerAdvice
public class WebMvcExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(WebMvcExceptionHandler.class);

    @ExceptionHandler(value={BizException.class})
    public JsonResult<Void> bizExceptionHandler(BizException e) {
        log.warn("BizException [{}]", (Object)e.getMessage(), (Object)e);
        return JsonResult.fail((String)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class, BindException.class})
    public JsonResult<Void> methodArgumentNotValidExceptionHandler(Exception e) {
        BindingResult bindResult = null;
        if (e instanceof BindException) {
            bindResult = ((BindException)e).getBindingResult();
        } else if (e instanceof MethodArgumentNotValidException) {
            bindResult = ((MethodArgumentNotValidException)e).getBindingResult();
        }
        String message = "\u53c2\u6570\u9519\u8bef";
        if (bindResult != null && bindResult.hasErrors()) {
            ObjectError objectError = (ObjectError)bindResult.getAllErrors().get(0);
            message = objectError.getDefaultMessage();
        }
        return JsonResult.fail((String)BaseError.PARAM_ERROR.getCode(), (String)message);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public JsonResult<Void> illegalArgumentExceptionHandler(IllegalArgumentException e) {
        log.warn("IllegalArgumentException", (Throwable)e);
        return JsonResult.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={UndeclaredThrowableException.class})
    public JsonResult<Void> sentinelExceptionHandler(UndeclaredThrowableException e) {
        Throwable throwable = e.getUndeclaredThrowable();
        if (throwable instanceof DegradeException) {
            return JsonResult.fail((String)BaseError.API_DEGRADE.getCode(), (String)BaseError.API_DEGRADE.getMsg());
        }
        if (throwable instanceof BlockException) {
            return JsonResult.fail((String)BaseError.API_FLOW.getCode(), (String)BaseError.API_FLOW.getMsg());
        }
        return JsonResult.fail((String)BaseError.SYSTEM_ERROR.getCode(), (String)BaseError.SYSTEM_ERROR.getMsg());
    }

    @ExceptionHandler(value={Exception.class})
    public JsonResult<Void> exceptionHandler(Exception e, HttpServletRequest request) {
        String message = e.getMessage();
        if (e instanceof InvocationTargetException && message == null) {
            message = ((InvocationTargetException)e).getTargetException().getMessage();
        }
        log.error("Exception [{} -> {}]:", new Object[]{request.getRequestURI(), message, e});
        return JsonResult.fail((String)BaseError.SYSTEM_ERROR.getCode(), (String)BaseError.SYSTEM_ERROR.getMsg());
    }
}

