/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.web.servlet;

import cn.com.duiba.local.ext.api.exception.BizException;
import cn.com.duiba.local.ext.sentinel.SentinelExceptionEnum;
import cn.com.duiba.local.wolf.entity.JsonResult;
import cn.com.duiba.local.wolf.message.BaseError;
import cn.hutool.core.io.IoUtil;
import cn.hutool.http.ContentType;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeException;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.error.ErrorAttributeOptions;
import org.springframework.boot.web.servlet.error.ErrorAttributes;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.ModelAndView;

@Order(value=0x7FFFFFF5)
public class WebMvcExceptionHandler
implements HandlerExceptionResolver {
    private static final Logger log = LoggerFactory.getLogger(WebMvcExceptionHandler.class);
    @Resource
    private ErrorAttributes errorAttributes;

    public ModelAndView resolveException(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, Object handler, @NonNull Exception ex) {
        response.setContentType(ContentType.build((ContentType)ContentType.JSON, (Charset)StandardCharsets.UTF_8));
        Throwable t = ex;
        try {
            if (t instanceof UndeclaredThrowableException) {
                t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
                return this.undeclaredExceptionHandler(t, response);
            }
            if (t instanceof BizException) {
                return this.bizExceptionHandler(t, response);
            }
            if (BlockException.isBlockException((Throwable)t)) {
                return this.sentinelExceptionHandler(t, response);
            }
            return this.globalExceptionHandler(t, request, response);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ModelAndView undeclaredExceptionHandler(Throwable t, HttpServletResponse response) throws IOException {
        if (t instanceof DegradeException) {
            this.ioWrite(response.getOutputStream(), JSON.toJSONString((Object)JsonResult.fail((String)BaseError.API_DEGRADE.getCode(), (String)BaseError.API_DEGRADE.getMsg())));
        } else if (t instanceof BlockException) {
            this.ioWrite(response.getOutputStream(), JSON.toJSONString((Object)JsonResult.fail((String)BaseError.API_FLOW.getCode(), (String)BaseError.API_FLOW.getMsg())));
        } else {
            JsonResult.fail((String)BaseError.SYSTEM_ERROR.getCode(), (String)BaseError.SYSTEM_ERROR.getMsg());
        }
        return new ModelAndView();
    }

    private ModelAndView sentinelExceptionHandler(Throwable t, HttpServletResponse response) throws IOException {
        String msg = t.getMessage().contains(SentinelExceptionEnum.DEGRADE.getType()) ? JSON.toJSONString((Object)JsonResult.fail((String)BaseError.API_DEGRADE.getCode(), (String)BaseError.API_DEGRADE.getMsg())) : JSON.toJSONString((Object)JsonResult.fail((String)BaseError.API_FLOW.getCode(), (String)BaseError.API_FLOW.getMsg()));
        this.ioWrite(response.getOutputStream(), msg);
        return new ModelAndView();
    }

    private ModelAndView globalExceptionHandler(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException {
        log.error("Exception [{} -> {}]:", new Object[]{request.getRequestURI(), t.getMessage(), t});
        this.ioWrite(response.getOutputStream(), JSON.toJSONString((Object)JsonResult.fail((String)BaseError.SYSTEM_ERROR.getCode(), (String)BaseError.SYSTEM_ERROR.getMsg())));
        return new ModelAndView();
    }

    private ModelAndView bizExceptionHandler(Throwable t, HttpServletResponse response) throws IOException {
        String code = null != ((BizException)t).getCode() ? ((BizException)t).getCode() : BaseError.SYSTEM_ERROR.getCode();
        response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        this.ioWrite(response.getOutputStream(), JSON.toJSONString((Object)JsonResult.fail((String)code, (String)t.getMessage())));
        return new ModelAndView();
    }

    private void ioWrite(ServletOutputStream outputStream, String msg) {
        IoUtil.writeUtf8((OutputStream)outputStream, (boolean)true, (Object[])new Object[]{msg});
    }

    private Map<String, Object> getErrorAttributes(HttpServletRequest request) {
        ServletWebRequest webRequest = new ServletWebRequest(request);
        return this.errorAttributes.getErrorAttributes((WebRequest)webRequest, ErrorAttributeOptions.defaults());
    }
}

