/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.autoconfigure.datasource;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.provider.AbstractDataSourceProvider;
import com.baomidou.dynamic.datasource.provider.DynamicDataSourceProvider;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceAutoConfiguration;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.datasource.ShardingDataSource;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(prefix="spring.shardingsphere", name={"enabled"}, havingValue="true")
@ConditionalOnClass(value={DynamicRoutingDataSource.class})
@AutoConfigureBefore(value={DynamicDataSourceAutoConfiguration.class, SpringBootConfiguration.class})
public class DataSourceAutoConfiguration {
    public static final String SHARDING_DATA_SOURCE_NAME = "sharding";
    @Resource
    private DynamicDataSourceProperties properties;
    @Lazy
    @Resource
    private ShardingDataSource shardingDataSource;

    @Bean
    public DynamicDataSourceProvider dynamicDataSourceProvider() {
        return new AbstractDataSourceProvider(){

            public Map<String, DataSource> loadDataSources() {
                HashMap dataSourceMap = Maps.newHashMap();
                dataSourceMap.put(DataSourceAutoConfiguration.SHARDING_DATA_SOURCE_NAME, DataSourceAutoConfiguration.this.shardingDataSource);
                Map shardingInnerDataSources = DataSourceAutoConfiguration.this.shardingDataSource.getDataSourceMap();
                dataSourceMap.putAll(shardingInnerDataSources);
                return dataSourceMap;
            }
        };
    }

    @Primary
    @Bean
    public DataSource dataSource() {
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(this.properties.getPrimary());
        dataSource.setStrict(this.properties.getStrict());
        dataSource.setStrategy(this.properties.getStrategy());
        dataSource.setP6spy(this.properties.getP6spy());
        dataSource.setSeata(this.properties.getSeata());
        return dataSource;
    }
}

