package cn.com.duiba.local.autoconfigure.core;

import org.springframework.context.SmartLifecycle;
import org.springframework.lang.NonNull;

/**
 * 这个类的子类会在spring容器关闭的早期被销毁（在其他所有bean开始销毁前），销毁顺序由getPhase的返回值决定，使用同一个phase的一组bean会
 * 被并发销毁。子类需要实现getPhase方法和stop的无参方法。
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
public abstract class EarlyClose implements SmartLifecycle {
    private volatile boolean isRunning = false;

    @Override
    public boolean isAutoStartup() {
        return true;
    }

    /**
     * 多个phase相同的SmartLifecycle的stop可以并发执行，所以要在新线程中关闭
     *
     * @param callback 回调
     */
    @Override
    public void stop(@NonNull Runnable callback) {
        isRunning = false;
        new Thread(() -> {
            try {
                EarlyClose.this.stop();
            } finally {
                callback.run();
            }
        }).start();
    }

    @Override
    public void start() {
        isRunning = true;
    }

    @Override
    public boolean isRunning() {
        return isRunning;
    }
}