package cn.com.duiba.local.autoconfigure.listener;

import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;

/**
 * 兑吧boot在spring启动前后的处理
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
public class DuibaBootRunListener implements SpringApplicationRunListener {
    private static boolean startingFlag = false;
    private final SpringApplication application;

    public DuibaBootRunListener(SpringApplication sa, String[] args) {
        this.application = sa;
    }

    @Override
    public void starting() {
        if (!startingFlag) {
            startingFlag = true;
            application.setBannerMode(Banner.Mode.OFF);
            new DuibaBootBanner().printBanner(System.out);
        }
    }
}