package cn.com.duiba.local.autoconfigure.mq.rocket;

import cn.hutool.extra.spring.SpringUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.apache.rocketmq.client.exception.MQClientException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

/**
 * Rocket MQ 消费者事件监听
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Slf4j
public class RocketMqConsumerListener {
    public static final String ROCKET_MQ_LISTENER_BEAN_NAME = "duibaRocketMqMessageListener";

    private boolean started = false;

    public synchronized void startRun() {
        if (started) {
            log.warn("rocketmq consumer have already started, please don't call start again");
            return;
        }
        DefaultMQPushConsumer consumer = SpringUtil.getBean("rocketMqConsumer");
        MessageListener rocketMqMessageListener;
        try {
            rocketMqMessageListener = SpringUtil.getBean(ROCKET_MQ_LISTENER_BEAN_NAME, MessageListener.class);
        } catch (NoSuchBeanDefinitionException e) {
            throw new IllegalArgumentException("bean id:[" + ROCKET_MQ_LISTENER_BEAN_NAME + "] class:[org.apache" +
                    ".rocketmq.client.consumer.listener.MessageListenerConcurrently] is not exist in spring's context," +
                    "请声明，否则不会启用rocketmq消费！");
        }
        if (rocketMqMessageListener instanceof MessageListenerConcurrently) {
            consumer.registerMessageListener((MessageListenerConcurrently) rocketMqMessageListener);
        } else if (rocketMqMessageListener instanceof MessageListenerOrderly) {
            consumer.registerMessageListener((MessageListenerOrderly) rocketMqMessageListener);
        }
        try {
            consumer.start();
        } catch (MQClientException e) {
            throw new RuntimeException(e);
        }
        started = true;
    }
}