package cn.com.duiba.local.autoconfigure.mq.rocket;

import lombok.Getter;
import lombok.Setter;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Rocket MQ自动装配属性
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Getter
@Setter
@ConfigurationProperties(prefix = RocketMqProperties.ROCKET_PREFIX)
public class RocketMqProperties {
    public static final String ROCKET_PREFIX = "duiba.rocketmq";

    /**
     * 服务地址
     */
    private String nameSrvAddress;

    /**
     * 消息提供者
     */
    private Producer producer;

    /**
     * 消息消费者
     */
    private Consumer consumer;

    @Getter
    @Setter
    public static class Producer {
        /**
         * 是否开启消息提供者，默认false
         */
        private Boolean enable = false;

        /**
         * 消息提供者分组<br>
         * 一个应用只需要创建一个，可以发送多个topic的消息<br>
         * 命名e.g.：PID-${spring.application.name}-${spring.profiles.active}
         */
        private String group;

        /**
         * 发送超时时间，默认400ms
         */
        private Integer sendMsgTimeoutMillis = 400;
    }

    @Getter
    @Setter
    public static class Consumer {
        /**
         * 是否开启消息消费者，默认false
         */
        private Boolean enable = false;

        /**
         * 消息消费者分组<br>
         * 一个应用只需要创建一个，可以消费多个topic的消息<br>
         * 命名e.g.：CID-${spring.application.name}-${spring.profiles.active}
         */
        private String group;

        /**
         * 需要订阅的topic，多个用英文半角逗号隔开，命名需要带上所在环境标志<br>
         * 命名规范e.g.：topic_${spring.profiles.active}
         */
        private String topics;

        /**
         * 指定消费模型，默认集群
         *
         * @see MessageModel
         */
        private MessageModel messageModel = MessageModel.CLUSTERING;

        /**
         * 消息消费的最大重试次数，默认16次<br>
         * 注：每次重试次数间隔会变大
         */
        private Integer maxReConsumeTimes = 16;
        /**
         * 消费最小线程数量，默认20
         */
        private Integer consumeMinThreadNumber = 20;

        /**
         * 消费最大线程数量，最大值是Math.max(你设置的值,64)，默认64
         */
        private Integer consumeMaxThreadNumber = 64;

        /**
         * MessageListener监听器每次接受本地队列的消息是多少条（默认1条，注意这个配置不能控制每次从rocketmq服务器拉取的条数）
         */
        private Integer consumeMessageBatchMaxSize = 1;
    }
}