/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.local.wolf.entity;

public class JsonResult<T> {
    private static final String DEFAULT_FAIL_CODE = "-1";
    private static final String DEFAULT_SUCCESS_CODE = "0";
    private boolean success;
    private String desc;
    private T data;
    private String code;
    private long timestamp;

    private JsonResult() {
    }

    public static <T> JsonResult<T> fail(String code, String desc) {
        JsonResult<T> result = new JsonResult<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }

    public static <T> JsonResult<T> fail(String desc) {
        return JsonResult.fail(DEFAULT_FAIL_CODE, desc);
    }

    public static <T> JsonResult<T> fail(String code, String desc, T data) {
        JsonResult<T> result = new JsonResult<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        result.setData(data);
        return result;
    }

    public static <T> JsonResult<T> fail(String desc, T data) {
        return JsonResult.fail(DEFAULT_FAIL_CODE, desc, data);
    }

    public static <T> JsonResult<T> success(String code, T data) {
        JsonResult<T> result = new JsonResult<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(true);
        result.setCode(code);
        result.setData(data);
        result.setDesc("OK");
        return result;
    }

    public static <T> JsonResult<T> success(T data) {
        return JsonResult.success(DEFAULT_SUCCESS_CODE, data);
    }

    public static <T> JsonResult<T> success() {
        return JsonResult.success(DEFAULT_SUCCESS_CODE, null);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getDesc() {
        return this.desc;
    }

    public T getData() {
        return this.data;
    }

    public String getCode() {
        return this.code;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonResult)) {
            return false;
        }
        JsonResult other = (JsonResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        if (this$desc == null ? other$desc != null : !this$desc.equals(other$desc)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof JsonResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }

    public String toString() {
        return "JsonResult(success=" + this.isSuccess() + ", desc=" + this.getDesc() + ", data=" + this.getData() + ", code=" + this.getCode() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

