package cn.com.duiba.local.wolf.context;

import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.Locale;

/**
 * request context
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
public class RequestContext {
    private static final ThreadLocal<HttpServletRequest> REQUEST = new InheritableThreadLocal<>();

    /**
     * 设置request，保存在ThreadLocal中
     *
     * @param req request
     */
    public static void setRequest(HttpServletRequest req) {
        REQUEST.set(req);
    }

    /**
     * 获取HttpServletRequest
     *
     * @return HttpServletRequest
     */
    public static HttpServletRequest getRequest() {
        HttpServletRequest req = REQUEST.get();
        if (req == null) {
            RequestAttributes attributes = RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                req = ((ServletRequestAttributes) attributes).getRequest();
            }
        }
        return req;
    }

    /**
     * 清除数据，防止内存泄露。
     */
    public static void clean() {
        REQUEST.remove();
    }

    /**
     * 获取本地化，从HttpServletRequest中获取，没有则返回Locale.SIMPLIFIED_CHINESE
     *
     * @return Locale
     */
    public static Locale getLocal() {
        HttpServletRequest req = getRequest();
        if (req == null) {
            return Locale.SIMPLIFIED_CHINESE;
        }
        return req.getLocale();
    }
}