package cn.com.duiba.local.wolf.message;

import cn.com.duiba.local.ext.api.exception.BizException;
import cn.com.duiba.local.wolf.context.RequestContext;
import lombok.Setter;

import java.util.Locale;
import java.util.Objects;

/**
 * Error 构造对象
 *
 * @author zhoujunquan@duiba.com.cn
 * @version 0.0.1
 * @since 0.0.1
 **/
@Setter
public class ErrorMeta implements Error<String> {
    private String code;
    private String msg;
    private String isvModule;

    public ErrorMeta(String isvModule, String code, String msg) {
        super();
        Objects.requireNonNull(isvModule, "isvModule不能为null");
        Objects.requireNonNull(code, "code不能为null");
        Objects.requireNonNull(msg, "msg不能为null");
        this.isvModule = isvModule;
        this.code = code;
        this.msg = msg;
    }

    public ErrorMeta(String code, String msg) {
        super();
        this.code = code;
        this.msg = msg;
    }

    @Override
    public String getMsg() {
        return msg;
    }

    @Override
    public String getCode() {
        return code;
    }

    public String getIsvModule() {
        return isvModule;
    }

    /**
     * 获取bizException
     *
     * @param params 占位符
     * @return bizException
     */
    public BizException getException(Object... params) {
        return this.getException(RequestContext.getLocal(), params);
    }

    /**
     * 获取bizException
     *
     * @param locale 请求中的local
     * @param params 占位符
     * @return bizException
     */
    public BizException getException(Locale locale, Object... params) {
        Error<String> error = ErrorFactory.getError(this, locale, params);
        return new BizException(error.getMsg()).withCode(error.getCode());
    }
}