package cn.com.duiba.mall.center.api.domain.enums;

import cn.com.duiba.mall.center.api.domain.MallCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author zyj
 * @date 2018/6/25
 */
public enum ActivityStatusEnum {
    /**
     * 营销活动状态
     * auditStatus
     */
    OPENING(1,"开启"),
    CLOSED(2,"关闭");
    private static final Map<Integer, ActivityStatusEnum> ENUM_MAP = new HashMap<>();
    static{
        for(ActivityStatusEnum activityStatusEnum : values()){
            ENUM_MAP.put(activityStatusEnum.getValue(), activityStatusEnum);
        }
    }

    public static ActivityStatusEnum getByCode(Integer code){
        ActivityStatusEnum activityStatusEnum = ENUM_MAP.get(code);
        if(activityStatusEnum == null){
            throw new MallCenterException("不支持的状态类型");
        }
        return activityStatusEnum;
    }

    private int    value;
    private String desc;

    ActivityStatusEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
