package cn.com.duiba.mall.center.api.remoteservice.shop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.shop.AppItemActivityRelationDto;
import cn.com.duiba.mall.center.api.domain.dto.shop.MarketActivityDto;

import java.util.List;

/**
 *
 * @author zyj
 * @date 2018/6/26
 */
@AdvancedFeignClient
public interface RemoteAppItemActivityRelationService {
    /**
     * 批量插入
     * @param appItemActivityRelationDtos
     * @return
     */
    int addRelations(List<AppItemActivityRelationDto> appItemActivityRelationDtos);
    /**
     * 批量删除
     */
    int deleteRelations(List<AppItemActivityRelationDto> appItemActivityRelationDtos);
    /**
     * 根据营销活动id查询
     */
    List<AppItemActivityRelationDto> selectByActivityId(Long activityId);
    /**
     * 根据商品ids查询
     */
    List<AppItemActivityRelationDto> seleteByItemIds(List<Long> itemIds);
    /**
     * 移除一个商品
     */
    boolean deleteRelation(AppItemActivityRelationDto appItemActivityRelationDto);
    /**
     * 根据商品id查询
     */
    AppItemActivityRelationDto selectByItemId(Long itemId);
    /**
     * 删除对应活动下面的所有商品
     */
    int deleteRelationByActivityId(Long activityId);

    /**
     * 保存活动 ，同时更新营销活动商品关联表
     */
    void updateActivityIdAndRelations(MarketActivityDto marketActivityDto,List<Long> itemIds);


    
}
