package cn.com.duiba.mall.center.api.remoteservice.shop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.shop.ConsumerTrolleyDto;
import cn.com.duiba.mall.center.api.domain.dto.shop.TrolleyItemsDto;
import cn.com.duiba.mall.center.api.domain.enums.SelectedStatusEnum;

import java.util.List;

/**
 * 购物车相关接口
 * @author chengsiyi
 * @date 2018/6/27 14:03
 */
@AdvancedFeignClient
public interface RemoteTrolleyItemsService {

    /**
     * 加入购物车
     * @param trolley 商品
     * @return 添加成功的ID
     */
    Long add(TrolleyItemsDto trolley);

    /**
     * 获取购物车商品列表
     * @param consumerId 用户ID
     * @return 购物车商品列表
     */
    ConsumerTrolleyDto getItemsByConsumerId(Long consumerId);

    /**
     * 移除购物车内的商品
     * @param consumerId 用户ID
     * @param itemIds 商品IDs
     * @return 移除结果
     */
    Integer removeItems(Long consumerId, List<Long> itemIds);

    /**
     * 修改商品信息（选中状态，商品数量）
     * @param trolley 商品信息
     * @return 修改记录
     */
    Integer updateItem(TrolleyItemsDto trolley);

    /**
     * 全选操作
     * @param consumerId    用户ID
     * @param itemIds   商品IDs
     * @param selected  选中状态
     * @return 操作结果
     */
    Integer selectAllItems(Long consumerId, List<Long> itemIds, SelectedStatusEnum selected);
}
