package cn.com.duiba.mall.center.api.remoteservice.discount;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 商品关联的优惠券
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteDiscountGoodsService {
    /**
     * 根据商品id找到对应的优惠券id
     *
     * @param appItemId 商品id
     * @return 优惠券id集合
     */
    List<Long> listTicketIdsByAppItemId(Long appItemId);
}
