package cn.com.duiba.mall.center.api.domain.enums.seckill;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/02/01 11:05.
 */
public enum SecKillActForUnitRunStatusEnum {
    STATUS_INIT(0, "未开始"),
    STATUS_ING(10, "进行中"),
    STATUS_ING_NO_STOCK(11, "进行中且库存不足"),
    STATUS_ING_SEC_LIMIT(12, "进行中且已秒光"),
    STATUS_END(20, "已结束"),
    ;

    private int code;
    private String desc;

    private static Map<Integer, SecKillActForUnitRunStatusEnum> enumMap = Maps.newHashMap();

    static {
        for(SecKillActForUnitRunStatusEnum enumVal: SecKillActForUnitRunStatusEnum.values()) {
            enumMap.put(enumVal.getCode(), enumVal);
        }
    }

    SecKillActForUnitRunStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SecKillActForUnitRunStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
