package cn.com.duiba.mall.center.api.remoteservice.groupbuy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.PaginationDto;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyActConfDto;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyActConfListParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyActConfParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteGroupBuyActConfService {


    GroupBuyActConfDto getSimpleActConf(Long actId);


    /**
     * 新增或者修改
     * @param groupBuyActConfParam
     * @return
     */
    int saveOrUpdate(GroupBuyActConfParam groupBuyActConfParam);

    /**
     * 列表查询拼团活动
     * @param groupBuyActConfListParam
     * @return
     */
    PaginationDto<GroupBuyActConfDto> getGroupBuyActConfList(GroupBuyActConfListParam groupBuyActConfListParam);

    /**
     * 查询总数
     * @param groupBuyActConfListParam
     * @return
     */
    Long countByParam(GroupBuyActConfListParam groupBuyActConfListParam);
    /**
     * getById
     * @param id
     * @return
     */
    GroupBuyActConfDto getById(Long id);

    /**
     * 逻辑删除
     * @param id
     * @return
     */
    int deleteById(Long id);
}
