package cn.com.duiba.mall.center.api.domain.enums.fulcredits;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by HePeng on 2019/01/14 14:12.
 */
public enum FulcreditsActConfStatusEnum {
    STATUS_DISABLE(0, "已失效"),
    STATUS_ENABLE(1, "有效"),
    ;

    private int code;
    private String desc;

    private static Map<Integer, FulcreditsActConfStatusEnum> enumMap = Maps.newHashMap();

    static {
        for(FulcreditsActConfStatusEnum enumVal: FulcreditsActConfStatusEnum.values()) {
            enumMap.put(enumVal.getCode(), enumVal);
        }
    }

    FulcreditsActConfStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static FulcreditsActConfStatusEnum getByCode(Integer code) {
        return enumMap.get(code);
    }

    public int getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
