package cn.com.duiba.mall.center.api.domain.enums.groupbuy;

/**
 * 拼团团状态
 * 团状态，0创建，1拼团中，10成功，20 失败，规定时间内未成团，21 失败，开发者失效活动
 */
public enum GroupBuyGroupStatusEnum {
    CREATE(0, "创建"),
    GROUP_BUY_ING(1, "拼团中"),
    SUCCESS(10, "拼团成功"),
    ERROR_TIME_OUT(20, "规定时间内未成团"),
    ERROR_INVALID(21, "开发者失效活动"),
    ;

    private Integer code;
    private String desc;

    GroupBuyGroupStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
