package cn.com.duiba.mall.center.api.domain.enums.groupbuy;

/**
 * 拼团订单状态
 * 订单状态，0待支付 1支付成功，拼团中，10成功，20失败,规定时间内未成团，21失败,开发者失效活动，22失败,团已满'
 */
public enum GroupBuyOrderStatusEnum {
    CREATE(0, "待支付"),
    GROUP_BUY_ING(1, "拼团中"),
    SUCCESS(10, "拼团成功"),
    ERROR_TIME_OUT(20, "规定时间内未成团"),
    ERROR_INVALID(21, "开发者失效活动"),
    ERROR_GROUP_IS_FULL(22, "团已满"),
    ;

    private Integer code;
    private String desc;

    GroupBuyOrderStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
