package cn.com.duiba.mall.center.api.remoteservice.groupbuy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyActConfDto;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyDetailDto;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyOrderDto;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyActConfListParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyActConfParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyCreateParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyOrderUpdateParam;

import java.util.List;

/**
 * @author czw
 */
@AdvancedFeignClient
public interface RemoteGroupBuyDetailService {
    /**
     * 参团
     * @param param
     */
    GroupBuyOrderDto joinGroup(GroupBuyCreateParam param);

    /**
     * 发起拼团
     * @param param
     * @return 团id
     */
    GroupBuyOrderDto createGroup(GroupBuyCreateParam param);
    /**
     * 更新团订单
     * @param param
     */
    void updateOrderId(Long groupOrderId,Long orderId);

    /**
     * 支付回调后的更新
     *
     * @param groupOrderId
     * @return
     */
    GroupBuyOrderDto updateAfterPaySuccess(Long groupOrderId,Long consumerId,Long groupId);

    /**
     * 拼团成功的处理
     * @param groupId
     * @return
     */
    GroupBuyDetailDto doGroupSuccess(Long groupId);
    /**
     * 拼团订单未支付的处理
     * @param groupOrderId 拼团订单号
     * @return
     */
    void doGroupOrderFail(Long groupOrderId);
}
