package cn.com.duiba.mall.center.api.domain.dto.discount;

import com.alibaba.fastjson.annotation.JSONField;

import java.io.Serializable;
import java.util.Date;

/**
 * 优惠券
 * @author fja
 */
public class DiscountTicketDto implements Serializable {

    /**
     * 主键
     */
    private Long id;

    /**
     * 优惠券名称
     */
    private String discountTitle;

    /**
     * appid
     */
    private Long appId;

    /**
     * 库存id
     */
    private Long stockId;

    /**
     * 1：上架、0：下架
     */
    private Integer discountStatus;

    /**
     * 1: 满减券，2：满折券
     */
    private Integer discountType;

    /**
     * 0: 不可叠加，1：可叠加
     */
    private Integer combineType;

    /**
     * 使用范围 1: 全品类，2：全品类（自有），3：全品类（兑吧），4：单品券，5：分组类
     */
    private Integer discountScope;

    /**
     * 满减金额（单位分）、满折百分比
     */
    private Long discountAmount;

    /**
     * 使用门槛 （单位分）
     */
    private Long discountThreshold;

    /**
     * 0: 无限制，1：白名单用户
     */
    private Integer discountUserType;

    /**
     * 1: 领取，2：推送
     */
    private Integer distributeType;

    /**
     * 使用限制次数
     */
    private Integer useCountLimit;

    /**
     * 获取限制次数
     */
    private Integer receiveCountLimit;

    /**
     * 有效期开始日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date effectiveStartDate;

    /**
     * 有效期结束日期
     */
    @JSONField(format = "yyyy-MM-dd")
    private Date effectiveEndDate;

    /**
     * 使用开始时段 例如：09:30:00
     */
    private String useStartTime;

    /**
     * 使用结束时段
     */
    private String useEndTime;

    /**
     * 0：未删除、1：删除
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 1:领取、0：未领取
     */
    private Integer isAcquired;
    /**
     * 扩展
     */
    private String extraJson;

    /**
     * 待领取的次数
     */
    private Integer canToGetNum;

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return id;
    }

    public void setDiscountTitle(String discountTitle) {
        this.discountTitle = discountTitle;
    }

    public String getDiscountTitle() {
        return discountTitle;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setStockId(Long stockId) {
        this.stockId = stockId;
    }

    public Long getStockId() {
        return stockId;
    }

    public void setDiscountStatus(Integer discountStatus) {
        this.discountStatus = discountStatus;
    }

    public Integer getDiscountStatus() {
        return discountStatus;
    }

    public void setDiscountType(Integer discountType) {
        this.discountType = discountType;
    }

    public Integer getDiscountType() {
        return discountType;
    }

    public void setCombineType(Integer combineType) {
        this.combineType = combineType;
    }

    public Integer getCombineType() {
        return combineType;
    }

    public void setDiscountScope(Integer discountScope) {
        this.discountScope = discountScope;
    }

    public Integer getDiscountScope() {
        return discountScope;
    }

    public void setDiscountAmount(Long discountAmount) {
        this.discountAmount = discountAmount;
    }

    public Long getDiscountAmount() {
        return discountAmount;
    }

    public void setDiscountThreshold(Long discountThreshold) {
        this.discountThreshold = discountThreshold;
    }

    public Long getDiscountThreshold() {
        return discountThreshold;
    }

    public void setDiscountUserType(Integer discountUserType) {
        this.discountUserType = discountUserType;
    }

    public Integer getDiscountUserType() {
        return discountUserType;
    }

    public void setDistributeType(Integer distributeType) {
        this.distributeType = distributeType;
    }

    public Integer getDistributeType() {
        return distributeType;
    }

    public void setUseCountLimit(Integer useCountLimit) {
        this.useCountLimit = useCountLimit;
    }

    public Integer getUseCountLimit() {
        return useCountLimit;
    }

    public void setReceiveCountLimit(Integer receiveCountLimit) {
        this.receiveCountLimit = receiveCountLimit;
    }

    public Integer getReceiveCountLimit() {
        return receiveCountLimit;
    }

    public void setEffectiveStartDate(Date effectiveStartDate) {
        this.effectiveStartDate = effectiveStartDate;
    }

    public Date getEffectiveStartDate() {
        return effectiveStartDate;
    }

    public void setEffectiveEndDate(Date effectiveEndDate) {
        this.effectiveEndDate = effectiveEndDate;
    }

    public Date getEffectiveEndDate() {
        return effectiveEndDate;
    }

    public void setUseStartTime(String useStartTime) {
        this.useStartTime = useStartTime;
    }

    public String getUseStartTime() {
        return useStartTime;
    }

    public void setUseEndTime(String useEndTime) {
        this.useEndTime = useEndTime;
    }

    public String getUseEndTime() {
        return useEndTime;
    }

    public void setDeleted(Integer deleted) {
        this.deleted = deleted;
    }

    public Integer getDeleted() {
        return deleted;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }

    public String getExtraJson() {
        return extraJson;
    }

    public Integer getIsAcquired() {
        return isAcquired;
    }

    public void setIsAcquired(Integer isAcquired) {
        this.isAcquired = isAcquired;
    }

    public Integer getCanToGetNum() {
        return canToGetNum;
    }

    public void setCanToGetNum(Integer canToGetNum) {
        this.canToGetNum = canToGetNum;
    }
}

