package cn.com.duiba.mall.center.api.domain.enums.discount;

/**
 * @author fja
 */
public enum DiscountTypeEnum {
    DELETED(1, "删除"),
    NON_DELETED(0, "未删除"),

    STATUS_ON(1, "上架"),
    STATUS_OFF(0, "下架"),

    TYPE_CASH_DECREASE(1, "满减券"),
    TYPE_CASH_DISCOUNT(2, "满折券"),

    SCOPE_ALL_CATEGORY(1, "全品类"),
    SCOPE_DEVELOPER_EXCLUSIVE(2, "全品类-开发者"),
    SCOPE_DUIBA_EXCLUSIVE(3, "全品类-兑吧"),
    SCOPE_SINGLE(4, "单品类"),

    USER_NO_LIMIT(0, "无限制"),
    USER_WHITE_LIST(1, "白名单"),

    USER_ACQUIRED(1, "已领取"),
    USER_NOT_ACQUIRED(0, "未领取"),

    COMBINE(1, "可叠加"),
    NOT_COMBINE(0, "不可叠加")
    ;
    private Integer code;
    private String desc;

    DiscountTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
