package cn.com.duiba.mall.center.api.domain.enums.groupbuy;

import java.util.Objects;

/**
 * @author: pengyi
 * @description:
 * @date: 2021/11/25 下午1:52
 */
public enum GroupBuyDetailStatusEnum {
    // 未参与拼团
    WAIT_GROUP_BUY("WAIT_GROUP_BUY",0,"未拼团"),
    // 支付成功，正在拼团
    GROUP_BUY_ING("GROUP_BUY_ING",1,"拼团中"),
    GROUP_BUY_SUCCESS("GROUP_BUY_SUCCESS",10,"拼团成功"),
    // B端强制拼团活动失效
    GROUP_BUY_INVALID("GROUP_BUY_INVALID",21,"拼团失效"),
    // 活动时间内未拼团成功
    GROUP_BUY_FAIL("GROUP_BUY_FAIL",20,"拼团失败"),
    // 好友拼团活动已满员
    GROUP_BUY_LIMIT("GROUP_BUY_LIMIT",22,"拼团满员"),
    // 拼团活动时间已结束
    GROUP_BUY_END("GROUP_BUY_END",98,"拼团结束"),
    ;

    private String code;

    private Integer codeInt;

    private String desc;

    GroupBuyDetailStatusEnum(String code, Integer codeInt,  String desc) {
        this.code = code;
        this.codeInt = codeInt;
        this.desc = desc;
    }

    public static GroupBuyDetailStatusEnum getByCodeInt(Integer codeInt) {
        if (codeInt == null) {
            return null;
        }
        GroupBuyDetailStatusEnum[] values = GroupBuyDetailStatusEnum.values();
        for (GroupBuyDetailStatusEnum value : values) {
            if (Objects.equals(value.getCodeInt(),codeInt)) {
                return value;
            }
        }
        return null;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getCodeInt() {
        return codeInt;
    }

    public void setCodeInt(Integer codeInt) {
        this.codeInt = codeInt;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
