package cn.com.duiba.mall.center.api.remoteservice.groupbuy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.PaginationDto;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyActConfDto;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyActConfListParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyActConfParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteGroupBuyActConfService {

    /**
     * 根据商品id查询开启的且活动结束时间大于当前时间未删除的活动
     * @param actId
     * @return
     */
    GroupBuyActConfDto getCacheSimpleActConfByAppItemId(Long actId);


    /**
     * 新增或者修改
     * @param groupBuyActConfParam
     * @return
     */
    Long saveOrUpdate(GroupBuyActConfParam groupBuyActConfParam);

    /**
     * 列表查询拼团活动
     * @param groupBuyActConfListParam
     * @return
     */
    PaginationDto<GroupBuyActConfDto> getGroupBuyActConfList(GroupBuyActConfListParam groupBuyActConfListParam);

    /**
     * 查询总数
     * @param groupBuyActConfListParam
     * @return
     */
    Long countByParam(GroupBuyActConfListParam groupBuyActConfListParam);
    /**
     * getById
     * @param id
     * @return
     */
    GroupBuyActConfDto getById(Long id);

    /**
     * 逻辑删除
     * @param id
     * @return
     */
    Long deleteById(Long id);

    /**
     * 查询商品是否已存在拼团活动中
     * @param appId
     * @param appItemIds
     * @return
     */
    List<GroupBuyActConfDto> getGroupBuyActConfByAppItemIds(Long appId, List<Long> appItemIds);

    /**
     * 失效活动
     * @param appId
     * @param appItemIds
     * @return
     */
    void doActInvalid(Long actId);

}
