package cn.com.duiba.mall.center.api.remoteservice.groupbuy;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.groupbuy.GroupBuyOrderDto;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyOrderListParam;
import cn.com.duiba.mall.center.api.domain.paramquary.groupbuy.GroupBuyOrderQueryParam;

import java.util.List;


/**
 * @author meteor
 */
@AdvancedFeignClient
public interface RemoteGroupBuyOrderService {

    /**
     * 当前拼团商品销量
     * @param appId
     * @param actId
     * @return
     */
    Integer countSaleGroupBuyOrder(Long appId, Long actId);

    /**
     * 查询用户拼团订单记录(一条)
     * @param param
     * @return
     */
    GroupBuyOrderDto selectByCondition(GroupBuyOrderQueryParam param);

    /**
     * 查询用户拼团订单
     * @param param
     * @return
     */
    List<GroupBuyOrderDto> selectGroupBuyListByCondition(GroupBuyOrderListParam param);
}
