package cn.com.duiba.mall.center.api.remoteservice.discount;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.discount.ConsumerDiscountDto;

import java.util.List;

/**
 * 用户优惠券关联业务类
 *
 * @author haojiahong
 * @date 2021-11-16
 */
@AdvancedFeignClient
public interface RemoteConsumerDiscountService {

    /**
     * 根据使用状态，查询用户优惠券列表
     *
     * @param consumerId    用户cid
     * @param useStatusList 使用状态集合
     * @return
     */
    List<ConsumerDiscountDto> listByCidAndUseStatus(Long consumerId, List<Integer> useStatusList);

}
