package cn.com.duiba.mall.center.api.remoteservice.discount;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.discount.DiscountTicketDetailDto;
import cn.com.duiba.mall.center.api.domain.dto.discount.DiscountTicketDto;
import cn.com.duiba.mall.center.api.domain.paramquary.discount.DiscountTicketListQueryParam;
import cn.com.duiba.mall.center.api.domain.paramquary.discount.UserAvailableTicketsQueryParam;

import java.util.List;

/**
 * 商品关联的优惠券
 *
 * @author fja
 */
@AdvancedFeignClient
public interface RemoteDiscountTicketService {


    /**
     * 新建优惠券
     * @param discountTicketDto
     * @return
     */
    Long save(DiscountTicketDto discountTicketDto);

    /**
     * 根据id 批量查询优惠券
     *
     * @param ids 主键
     * @return 优惠券
     */
    List<DiscountTicketDto> listByIds(List<Long> ids);


    /**
     * 根据id查询优惠券
     * @param id
     * @return
     */
    DiscountTicketDetailDto findById(Long id);
    /**
     * 批量查询优惠券
     *
     * @param queryParam 查询条件
     * @return 优惠券
     */
    List<DiscountTicketDto> listByQueryParam(DiscountTicketListQueryParam queryParam);

    /**
     * 用户可用优惠券
     *
     * @param queryParam 查询条件
     * @return
     */
    List<DiscountTicketDto> listUserAvailableTickets(UserAvailableTicketsQueryParam queryParam) throws BizException;

    /**
     * 更新库存id
     * @param id
     * @param stockId
     * @return
     */
    int updateStockIdById(Long id, Long stockId);

    /**
     * 更新状态
     * @param id
     * @param status
     * @return
     */
    int updateStatusById(Long id, Integer status);

    /**
     * 删除优惠券
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据id更新
     * @param discountTicketDto
     * @return
     */
    int updateById(DiscountTicketDto discountTicketDto);


    /**
     * 优惠券推送到指定的账户列表
     * @param discountId
     * @param consumerIds
     * @return
     */
    void pushToDesignativeUsers(Long discountId, List<Long> consumerIds) throws BizException;

}
