package cn.com.duiba.mall.center.api.remoteservice.vipgoods;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.vipgoods.VipGoodsGradeSkuConfigDto;

import java.util.List;

/**
 * 会员商品分层定价配置
 *
 * @Author: xuwei
 * @Date: 2019/05/16 15:08
 */
@AdvancedFeignClient
public interface RemoteVipGoodsGradeSkuConfigService {
    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    VipGoodsGradeSkuConfigDto findById(Long id);

    /**
     * 根据会员商品id和等级查询
     *
     * @param vipGoodsId
     * @param grade
     * @return
     */
    List<VipGoodsGradeSkuConfigDto> findByGoodsIdAndGrade(Long vipGoodsId, Integer grade);

    /**
     * 根据会员商品id和等级列表查询
     *
     * @param vipGoodsId
     * @param grades
     * @return
     */
    List<VipGoodsGradeSkuConfigDto> findByGoodsIdAndGrades(Long vipGoodsId, List<Integer> grades);

    /**
     * 根据会员商品id列表和等级查询
     *
     * @param vipGoodsIds
     * @param grade
     * @return
     */
    List<VipGoodsGradeSkuConfigDto> findByGoodsIdsAndGrade(List<Long> vipGoodsIds, Integer grade);

    /**
     * 根据会员商品id和等级和skuid查询
     *
     * @param vipGoodsId
     * @param grade
     * @param skuId
     * @return
     */
    VipGoodsGradeSkuConfigDto findByGoodsIdAndGradeAndSkuId(Long vipGoodsId, Integer grade, Long skuId);

    /**
     * 根据会员商品id列表查询
     *
     * @param vipGoodsIds
     * @return
     */
    List<VipGoodsGradeSkuConfigDto> findByGoodsIds(List<Long> vipGoodsIds);

    /**
     * 批量插入
     *
     * @param records
     * @return
     */
    List<Long> batchInsert(List<VipGoodsGradeSkuConfigDto> records);

    /**
     * 批量更新
     *
     * @param records
     * @return
     */
    int batchUpdate(List<VipGoodsGradeSkuConfigDto> records);

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    int batchDelete(List<Long> ids);
}