package cn.com.duiba.mall.center.api.domain.dto.discount;

import com.google.common.collect.Lists;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 与商品有关的优惠券
 *
 * @author fja
 */
public class GoodsTicketsWrapper implements Serializable {
    /**
     * 单品券
     */
    List<DiscountTicketDto> singleTickets = Collections.emptyList();
    /**
     * 全品券
     */
    List<DiscountTicketDto> multiTickets = Collections.emptyList();

    public GoodsTicketsWrapper() {}

    public GoodsTicketsWrapper(List<DiscountTicketDto> singleTickets, List<DiscountTicketDto> multiTickets) {
        this.singleTickets = singleTickets;
        this.multiTickets = multiTickets;
    }

    /**
     * 合并优惠券
     * @return -
     */
    public List<DiscountTicketDto> getAllTickets() {
        ArrayList<DiscountTicketDto> tickets = Lists.newArrayList(this.singleTickets);
        tickets.addAll(this.multiTickets);
        return tickets;
    }

    public List<DiscountTicketDto> getSingleTickets() {
        return singleTickets;
    }

    public void setSingleTickets(List<DiscountTicketDto> singleTickets) {
        this.singleTickets = singleTickets;
    }

    public List<DiscountTicketDto> getMultiTickets() {
        return multiTickets;
    }

    public void setMultiTickets(List<DiscountTicketDto> multiTickets) {
        this.multiTickets = multiTickets;
    }
}
