package cn.com.duiba.mall.center.api.remoteservice.shop;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.mall.center.api.domain.dto.shop.MarketActivitySupplierRelationDTO;
import cn.com.duiba.mall.center.api.domain.paramquary.MarketActivitySupplierRelationParam;

import java.util.List;

/**
 * @author qiurenjie
 * @date 2023-06-16 17:18
 */
@AdvancedFeignClient
public interface RemoteMarketActivitySupplierRelationService {

    /**
     * 新增营销活动供应商关系记录
     *
     * @param marketActivitySupplierRelationDTO
     * @return
     */
    Long insert(MarketActivitySupplierRelationDTO marketActivitySupplierRelationDTO);

    /**
     * 批量新增营销活动供应商关系记录
     *
     * @param supplierRelationDTOS
     */
    void batchInsert(List<MarketActivitySupplierRelationDTO> supplierRelationDTOS);

    /**
     * 根据主键ID删除
     */
    boolean deleteById(Long id);

    /**
     * 根据营销活动ID删除
     *
     * @return
     */
    void deleteByMarketActivityId(Long appId, Long marketActivityId);

    /**
     * 根据营销活动ID查询供应商关联
     *
     * @return
     */
    List<MarketActivitySupplierRelationDTO> queryList(MarketActivitySupplierRelationParam relationParam);

}
