/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.cloud.manage.service.sdk.handler;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtAuthority;
import cn.com.duiba.cloud.manage.service.sdk.handler.verification.PermissionVerification;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import cn.com.duiba.cloud.single.sign.on.contract.tool.SsoRequestTool;
import cn.com.duiba.wolf.entity.JsonResult;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class MgtAuthorityHandler
implements SsoFilterHandler {
    @Resource
    private PermissionVerification permissionVerification;

    public Boolean before(Object handler) throws SsoException {
        if (handler instanceof HandlerMethod) {
            HandlerMethod method = (HandlerMethod)handler;
            MgtAuthority authority = (MgtAuthority)AnnotationUtils.findAnnotation((Method)method.getMethod(), MgtAuthority.class);
            if (Objects.isNull(authority)) {
                return Boolean.TRUE;
            }
            try {
                Boolean verify = null;
                try {
                    verify = this.permissionVerification.verifyAuthority(authority.code());
                }
                catch (BizException e) {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)e.getCode(), (String)e.getMessage());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                    return false;
                }
                if (!verify.booleanValue()) {
                    SsoRequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JsonResult result = JsonResult.fail((String)"mss000001", (String)authority.message());
                    SsoRequestTool.getResponse().getWriter().write(JSON.toJSONString((Object)result));
                }
                return verify;
            }
            catch (IOException e) {
                throw new SsoRunTimeException((Throwable)e);
            }
        }
        return Boolean.TRUE;
    }

    public int getOrder() {
        return 50;
    }
}

