package cn.com.duiba.cloud.manage.service.sdk.aspect;

import cn.com.duiba.cloud.manage.service.sdk.annotation.MgtRights;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;

/**
 * 权益处理切面
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2021/12/8
 */
@Aspect
@Order(-1)
public class MgtRightsAspect {

    @Around("@annotation(cn.com.duiba.cloud.manage.service.sdk.annotation.MgtRights)")
    public Object rights(ProceedingJoinPoint joinPoint) throws Throwable {

        // 1. 获取权益注解
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        Method method = signature.getMethod();
        MgtRights rights = AnnotationUtils.findAnnotation(method, MgtRights.class);

        // 2. 校验权益并获取权益content
        Boolean hasRights = Boolean.TRUE;
        String code = "";
        String content = "{\"name\":\"123123\"}";

        // 3. 将权益content封装到请求中
        if (StringUtils.isNotBlank(content)) {
            Map<String, Object> contentMap = null;
            try {
                contentMap = JSONObject.parseObject(content, Map.class);
            } catch (Exception e) {
                throw new IllegalArgumentException(String.format("权益 %s 的content值 %s 非json格式", code, content), e);
            }

            // 只获取第一个参数进行封装
            Object arg0 = joinPoint.getArgs()[0];
            if (Objects.nonNull(arg0)) {
                Class<?> argClass = arg0.getClass();
                for (Field field : argClass.getDeclaredFields()) {
                    if (contentMap.containsKey(field.getName())) {
                        ReflectionUtils.setField(field, arg0, contentMap.get(field.getName()));
                    }
                }
            }
        }

        return joinPoint.proceed();
    }

}
