package cn.com.duiba.message.service.api.enums;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019年01月29日 17:08
 * @descript: 早媒体结果状态码
 * @version: 1.0
 */
public enum CallEarlyCodeEnum {

    USER_TO_LINE(200002, "用户占线(通话中)"),
    HANG_UP(200005, "用户无法接通(不方便接听&正忙&无法接听)"),
    POWER_OFF(200010, "手机关机"),
    HALT(200011, "停机"),
    UNABLE_CONNECT(200007, "用户无法接通（不在服务区）"),
    SPACE(200004, "空号"),
    CALL_LOSS(200012, "呼损(呼叫受限)"),
    OTHER(200130, "其他（无法识别）\n");

    CallEarlyCodeEnum(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private int value;

    private String desc;

    public int value() {
        return value;
    }

    public String desc() {
        return desc;
    }

}
