package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.CallReport;
import cn.com.duiba.message.service.api.dto.CallResult;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019年01月29日 16:50
 * @descript:
 * @version: 1.0
 */
@AdvancedFeignClient
public interface RemoteCallService {

    /**
     * 打电话
     *
     * @param mobile   手机号
     * @param ttsParam 模版里的参数变量json（当模板中存在变量时需要设置此值）
     * @param ttsCode  电话模版（需要根据既定的模板生成的内容，业务方需要在阿里云语音服务控制台添加好对应的模板）
     * @return
     * @throws BizException
     */
    CallResult call(String ttsCode, String mobile, String ttsParam) throws BizException;

    /**
     * 查询呼叫记录
     *
     * @param callId 呼叫ID
     * @return
     * @throws BizException
     */
    CallReport queryCallReport(Long callId) throws BizException;


}
