package cn.com.duiba.message.service.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.message.service.api.dto.DingRobotDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRobotService {

    /**
     * 获取所有机器人列表
     *
     * @return
     */
    List<DingRobotDto> getAll();

    /**
     * 添加机器人
     *
     * @param dingRobotDto
     */
    void add(DingRobotDto dingRobotDto);

    /**
     * 更新机器人
     *
     * @param dingRobotDto
     */
    void update(DingRobotDto dingRobotDto);

    /**
     * 获取指定机器人
     *
     * @param id
     * @return
     */
    DingRobotDto get(Long id);

}
