package cn.com.duiba.message.service.api.dto;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-06-17 14:19
 * @descript: 普通消息，类型见：DingMsgTypeEnum
 * @version: 1.0
 */
@Data
@NoArgsConstructor
public class DingGeneralMsgRquest implements Serializable {

    private static final long serialVersionUID = -4501916173028507940L;

    /**
     * 首屏会话透出的展示内容
     */
    private String title;

    /**
     * 消息内容，如果是DingMsgTypeEnum.markdown类型的消息，支持markdown文本
     */
    private String content;

    /**
     * 消息类型为DingMsgTypeEnum.link设置生效
     * 消息点击链接地址，当发送消息为小程序时支持小程序跳转链接
     */
    private String linkUrl;

    /**
     * 发送消息是机器人时生效
     * 需要@的人列表
     */
    private List<Long> atAdminIds;
}
