/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.message.service.rest.controller;

import cn.com.duiba.message.service.api.remoteservice.RemoteLetterService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class SsePushNotifySchedule {
    private static final Logger log = LoggerFactory.getLogger(SsePushNotifySchedule.class);
    @Resource
    private RemoteLetterService remoteLetterService;
    private final Map<String, SseEmitter> emitters = new ConcurrentHashMap<String, SseEmitter>();

    void addEmitter(String receiveId, SseEmitter emitter) {
        this.emitters.put(receiveId, emitter);
    }

    void removeEmitter(String receiveId) {
        this.emitters.remove(receiveId);
    }

    @Async
    @Scheduled(fixedRate=10000L)
    public void doNotify() {
        ArrayList deadEmitters = Lists.newArrayList();
        List receiveIds = this.remoteLetterService.hasNewLetter(this.emitters.keySet());
        for (Map.Entry<String, SseEmitter> entry : this.emitters.entrySet()) {
            SseEmitter sseEmitter = entry.getValue();
            String receiveId = entry.getKey();
            boolean hasNew = receiveIds.contains(receiveId);
            SseEmitter.SseEventBuilder builder = SseEmitter.event().id(UUID.randomUUID().toString()).data((Object)hasNew);
            try {
                sseEmitter.send(builder);
            }
            catch (IOException e) {
                deadEmitters.add(receiveId);
            }
        }
        deadEmitters.forEach(this.emitters::remove);
    }
}

