package cn.com.duiba.millionaire.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by sty on 1/20/18.
 */
public enum RenascenceTypeEnum {
    INVITEOTHER(1, "邀请他人"),
    BEINVITED(2, "被邀请获得"),
    RENASCENCE(3, "复活消耗"),
    ACTIVITY(4, "活动消耗");

    private static Map<Integer, RenascenceTypeEnum> typeEnumMap = Maps.newHashMap();

    static {
        for (RenascenceTypeEnum typeEnum : RenascenceTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     * 通过code获取签到类型
     *
     * @param code
     * @return
     */
    public static RenascenceTypeEnum getByCode(int code) {
        RenascenceTypeEnum type = typeEnumMap.get(code);
        if(type == null){
            return null;
        }
        return type;
    }

    private Integer code;
    private String desc;

    RenascenceTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
