package cn.com.duiba.millionaire.center.api.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by xiaoxuda on 2018/1/31.
 */
public enum WithdrawStatusEnum {
    INIT(0, "初始化"),
    USER_PAYED(1, "用户预扣款"),
    DEV_PAYED(2, "开发者预扣款"),
    SUCCESS(3, "成功"),
    FAILED(4, "失败");

    private static final Map<Integer, WithdrawStatusEnum> statusMap = new HashMap<>();
    static{
        for(WithdrawStatusEnum statusEnum : values()){
            statusMap.put(statusEnum.code, statusEnum);
        }
    }

    private Integer code;
    private String desc;

    WithdrawStatusEnum(Integer code, String desc){
        this.code = code;
        this.desc = desc;
    }

    public static WithdrawStatusEnum getByCode(Integer code){
        return statusMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
