package cn.com.duiba.millionaire.center.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.millionaire.center.api.dto.MillionaireActivityDto;
import cn.com.duiba.millionaire.center.api.dto.MillionaireMainMeetingDto;
import cn.com.duiba.millionaire.center.api.requestParam.MillionaireActivityRequestParam;

import java.util.List;
import java.util.Map;

/**
 * Created by sty on 2018/1/18.
 *
 * 冲顶大会 分会场 配置
 */
@AdvancedFeignClient
public interface RemoteMillionaireActivityService {

    /**
     *
     * getActivityByIds:(这里用一句话描述这个方法的作用). <br/>
     * 根据分会场id list 查询分会场信息
     * @param activityIds
     * @return
     * @since JDK 1.8
     */
    List<MillionaireActivityDto> getActivityByIds(List<Long> activityIds);

    /**
     *
     * countMillionaireActivityList:(这里用一句话描述这个方法的作用). <br/>
     * 统计冲顶主会场条数
     * @param param
     * @return
     * @since JDK 1.8
     */
     Integer countMillionaireActivityList(MillionaireActivityRequestParam param);

    /**
     *
     * MillionaireActivityList:(这里用一句话描述这个方法的作用). <br/>
     * 统计冲顶主会场数据
     * pageNum  当前页码  每页大小 pageSize
     * @param param
     * @return
     * @since JDK 1.8
     */
     List<MillionaireActivityDto> getMillionaireActivityList(MillionaireActivityRequestParam param);

    /**
     *
     * findMillionaireActivityById:(这里用一句话描述这个方法的作用). <br/>
     * 查询 答题分会场数据
     *
     * @param id
     * @return
     * @since JDK 1.8
     */
     MillionaireActivityDto findMillionaireActivityById(Long id);

    /**
     *
     * openOrdelete:(这里用一句话描述这个方法的作用). <br/>
     * 根据id
     * @param id
     * @param status  1:开启，2：关闭,3：删除
     * @return
     * @since JDK 1.8
     */
     Boolean openOrDelete(Long id, Integer status);

    /**
     *
     * saveOrUPdateMillionaireActivity:(这里用一句话描述这个方法的作用). <br/>
     * 根据id 为 null 新增  id 不为null 是 更新
     * @param dto
     * @return
     * @since JDK 1.8
     */
     Boolean saveOrUpdateMillionaireActivity(MillionaireActivityDto dto);
}
