package cn.com.duiba.millionaire.center.api.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by sty on 1/20/18.
 */
public class ReturnErrorCode {
    private ReturnErrorCode(){}

    private static final Map<Integer, String> errCodeMap = new HashMap<>();
    static {
        errCodeMap.put(ReturnErrorCode.CAN_NOT_INVITE_SELF, "不能邀请自己");
        errCodeMap.put(ReturnErrorCode.NO_SHARECODE, "无效的邀请码");
        errCodeMap.put(ReturnErrorCode.ALREADY_USERD, "已填写过邀请码");
        errCodeMap.put(ReturnErrorCode.CAN_INVITE_IN_SECOND, "操作频繁,请稍后再试");
    }

    /**
     * 不能邀请自己
     */
    public static final int CAN_NOT_INVITE_SELF = 0;

    /**
     * 无效的邀请码
     */
    public static final int NO_SHARECODE = 1;

    /**
     * 已经填写过的邀请码
     */
    public static final int ALREADY_USERD = 2;

    /**
     * 指定时间内不能在输入码
     */
    public static final int CAN_INVITE_IN_SECOND = 3;

    public static String errorMsgByCode(Integer errorCode){
        return errCodeMap.get(errorCode);
    }
}
