package cn.com.duiba.millionaire.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by sunchangji on 2018/3/7.
 */
public enum ActivityTypeEnum {
    QUESTION(1,"百万答题"),
    GAME(2,"百万游戏");
    private static Map<Integer, ActivityTypeEnum> typeEnumMap = Maps.newHashMap();
    static {
        for (ActivityTypeEnum typeEnum : ActivityTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getType(), typeEnum);
        }
    }

    private int type;
    private String desc;

    ActivityTypeEnum(int type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public static ActivityTypeEnum finfByType(int type){
        return typeEnumMap.get(type);
    }

    public int getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
