package cn.com.duiba.millionaire.center.api.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * Created by sunchangji on 2018/2/24.
 */
public enum AppConfigProNameEnum {
    NO_ALIPAY("offLineCash","1","非支付宝提现,线下开发者自己打款给用户"),
    ALIPAY_DUIBA("onlineCashDuiba","1","支付宝在线提现,奖金由兑吧提供,不扣开发者资金");
    private static Map<String, AppConfigProNameEnum> typeEnumMap = Maps.newHashMap();

    static {
        for (AppConfigProNameEnum typeEnum : AppConfigProNameEnum.values()) {
            typeEnumMap.put(typeEnum.getPropName(), typeEnum);
        }
    }
    private String propName;
    private String propValue;
    private String desc;

    AppConfigProNameEnum(String propName,String propValue,String desc){
        this.propName = propName;
        this.propValue = propValue;
        this.desc = desc;
    }

    public static final String PRIX_REDIS = "mill_app_config_";
    /**
     * 通过proName获取类型
     *
     * @param proName
     * @return
     */
    public static AppConfigProNameEnum getByProName(String proName) {
        AppConfigProNameEnum proNameEnum = typeEnumMap.get(proName);
        if(proNameEnum == null){
            return null;
        }
        return proNameEnum;
    }

    public String getPropName() {
        return propName;
    }

    public String getPropValue() {
        return propValue;
    }

    public String getDesc() {
        return desc;
    }

}
